/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License. For a copy,
 * see http://www.gnu.org/licenses/gpl-2.0.html.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#ifndef _LIBSTR_H
#define _LIBSTR_H

#include "config.h"
#include <sys/types.h>

typedef struct type_keyvalue {
	char *key;
	char *value;

	struct type_keyvalue *next;
} t_keyvalue;

int  str2int(char *str);
char *remove_spaces(char *str);
char *uncomment(char *str);
char *strlower(char *str);
int  split_string(const char *str, char **key, char **value, char c);
int  split_configline(const char *str, char **key, char **value);
int  parse_keyvalue(char *line, t_keyvalue **kvlist, char *delimiter);

#endif
