#ifndef _COMMAND_H
#define _COMMAND_H

#include "config.h"
#include "serverconfig.h"

#ifdef HAVE_COMMAND
#define cc_DISCONNECT -1
#define cc_SHUTDOWN   -2
#define cc_RELOADCONF  1

typedef struct type_admin {
	int socket;
	FILE *fp;
	bool allowed;
	int timer;

	struct type_admin *next;
} t_admin;

void tell_cc_Im_busy(void);
void tell_cc_Im_done(void);
void tell_children_Im_busy(void);
void tell_children_Im_done(void);

void init_commandmodule(void);
int add_admin(int sock);
void remove_admin(int sock);
void check_adminlist(void);
t_admin *first_admin(void);
t_admin *next_admin(void);
int handle_admin(t_admin *admin, t_config *config);
void disconnect_admins(void);
#endif

#endif
