#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <unistd.h>
#include <string.h>
#ifdef HAVE_CRYPT_H
#include <crypt.h>
#endif
#ifdef HAVE_RPCSVC_CRYPT_H
#include <rpcsvc/crypt.h>
#endif
#include "session.h"
#include "libstr.h"

/* If a groupfile exist, is a user in the right group?
 *  */
bool group_oke(t_session *session, char *user) {
	bool retval;
	FILE *gfp;
	char *pwfile, *line, *item, *rest;
	bool groupfound;
	int i;

	if (session->host->GroupFile != NULL) {
		retval = false;
		pwfile = file_in_chroot(session, session->host->GroupFile);
		if ((gfp = fopen_neighbour(pwfile, "r", session->file_on_disk)) != NULL) {
			if ((line = (char*)malloc(257)) != NULL) {
				*(line + 256) = '\0';
				while (fgets(line, 256, gfp) != NULL) {
					if (split_string(line, &item, &rest, ':') == 0) {
						groupfound = false;
						for (i = 0; i < session->host->RequiredGroup.size; i++) {
							if (strcmp(*(session->host->RequiredGroup.item + i), item) == 0) {
								groupfound = true;
								break;
							}
						}
						if (groupfound) {
							while (rest != NULL) {
								split_string(rest, &item, &rest, ' ');
								if (strcmp(user, item) == 0) {
									retval = true;
									break;
								}
							}
						}
					}
					if (retval == true) {
						break;
					}
				}
				free(line);
			}
			fclose(gfp);
		}
	} else {
		retval = true;
	}

	return retval;
}

/* Basic HTTP authentication.
 */
bool basic_http_authentication(t_session *session, char *auth_str) {
	bool retval = false;
	FILE *pfp;
	char *pwfile, *auth_user, *auth_passwd, *user, *passwd, *rest, *encrypted, salt[3];

	if ((auth_user = strdup(auth_str)) == NULL) {
		return false;
	}

	if (decode_base64(auth_user)) {
		auth_passwd = auth_user;
		while ((*auth_passwd != ':') && (auth_passwd != '\0')) {
			auth_passwd++;
		}
		*(auth_passwd++) = '\0';
		
		pwfile = file_in_chroot(session, session->host->PasswordFile);
		if ((pfp = fopen_neighbour(pwfile, "r", session->file_on_disk)) != NULL) {
			if ((user = (char*)malloc(257)) != NULL) {
				*(user + 256) = '\0';
				while ((passwd = fgets(user, 256, pfp)) != NULL) {
					while ((*passwd != ':') && (*passwd != '\0') && ((passwd - user) < 255)) {
						passwd++;
					}
					if ((passwd - user) < 255) {
						*passwd = '\0';
						/* User match?
						 */
						if (strcmp(auth_user, user) == 0) {
							if (group_oke(session, user) == false) {
								break;
							}

							rest = ++passwd;
							while ((*rest != ':') && (*rest != '\0') && (*rest != '\n') && ((rest - user) < 255)) {
								rest++;
							}
							if ((rest - user) < 255) {
								*rest = '\0';
								memcpy(salt, passwd, 2);
								salt[2] = '\0';
								encrypted = crypt(auth_passwd, salt);
								/* Password match?
								 */
								if (strcmp(encrypted, passwd) == 0) {
									session->remote_user = strdup(auth_user);
									retval = true;
									break;
								}
							}
						}
					}
				}
				free(user);
			}
			fclose(pfp);
		}
	}
	free(auth_user);

	return retval;
}

/* Digest HTTP authentication.
 */
bool digest_http_authentication(t_session *session, char *auth_str) {
	return false;
}

/* Check if the file is protected by an .hiawatha file with PasswordFile setting.
 */
bool permission_granted(t_session *session) {
	bool result;
	char *auth_str;

	if (session->host->PasswordFile == NULL) {
		result = true;
	} else if ((auth_str = get_headerfield("Authorization:", session->headerfields)) == NULL) {
		result = false;
	} else if (strlen(auth_str) < 7) {
		result = false;
	} else if (memcmp(auth_str, "Basic ", 6) == 0) {
		result = basic_http_authentication(session, auth_str + 6);
	} else if (memcmp(auth_str, "Digest ", 7) == 0) {
		result = digest_http_authentication(session, auth_str + 7);
	} else {
		result = false;
	}

	return result;
}
