#ifndef _LIBFS_H
#define _LIBFS_H

enum t_filetype { file, executable, directory, path_to };
enum t_isdir { is_dir, no_dir, no_access, not_found };
enum t_extbool { error = -1, no, yes };
typedef struct type_groups {
	int   number;
	gid_t *array;
} t_groups;

long filesize(char *filename);
enum t_extbool fs_access_allowed(char *filename, uid_t uid, gid_t gid, t_groups *groups, enum t_filetype filetype);
enum t_extbool contains_symlink(char *filename);
enum t_isdir is_directory(char *file);
void touch_logfile(char *dir, char *file, uid_t userid, gid_t groupid, mode_t mode);
int  if_modified_since(int handle, char *datestr);
FILE *fopen_neighbour(char *filename, char *mode, char *neighbour);

#endif
