#ifndef _LIBSSL_H
#define _LIBSSL_H

#include "config.h"
#ifdef HAVE_SSL
#include <openssl/err.h>
#include <openssl/ssl.h>

bool sslAccept(int socketFD, SSL **ssl);
bool sslConnect(int socketFD, SSL **ssl);
void sslCleanup(void);
bool sslInit(const char* sslKeyFile, const char* sslPassword);
int sslRecv(SSL *ssl, char *buffer, unsigned int maxlength);
int sslSend(SSL *ssl, char *buffer, unsigned int length);
int sslPasswordCB(char *passwordBuffer, int size, int rwflag, void *data);
int sslClose(SSL *ssl);
#endif

#endif
