#ifndef _SERVERCONFIG_H
#define _SERVERCONFIG_H

#include <pthread.h>
#include "mimetype.h"
#include "libfs.h"
#include "liblist.h"

typedef enum { root, part } t_pathmatch;
typedef enum { hiaconf, passwd } t_hdirsrc;

typedef struct type_homedir {
	char   *Username;
	uid_t  UserId;
	gid_t  GroupId;
	char   *Directory;

	struct type_homedir *next;
} t_homedir;

typedef struct type_CGIhandler {
	char       *handler;
	t_charlist extension;
	struct type_CGIhandler *next;
} t_CGIhandler;

typedef struct type_throttle {
	char          *filetype;
	unsigned long upload_speed;

	struct type_throttle *next;
} t_throttle;

typedef struct type_directory {
	char         *Path;
	t_pathmatch  PathMatch;
	uid_t        UserId;
	gid_t        GroupId;
	t_groups     Groups;
	bool         ExeCGI;
	bool         ExeCGIset;
	bool         ShowIndex;
	bool         ShowIndexSet;
	bool         FollowSymlinks;
	bool         FollowSymlinksSet;
	char         *PasswordFile;
	char         *GroupFile;
	t_charlist   RequiredGroup;
	t_accesslist *AccessList;
	t_charlist   ImageReferer;
	char         *ImgRefReplacement;
	t_keyvalue   *EnvirStr;

	/* Uploadspeed control
	 */
	int          MaxClients;
	int          Clients;
	long         UploadSpeed;
	long         SessionSpeed;
	pthread_mutex_t client_mutex;

	struct type_directory *next;
} t_directory;

typedef struct type_host {
	char          *WebsiteRoot;
	char          *StartFile;
	char          *ErrorHandler;
	int           ErrorCode;
	char          *LogFile;
	t_charlist    Hostname;
	bool          UserWebsites;
	bool          ExeCGI;
	bool          ShowIndex;
#ifdef HAVE_PLUGIN 
	bool          PluginActive;
#endif
	char          *LoginMessage;
	char          *PasswordFile;
	char          *GroupFile;
	t_charlist    RequiredBinding;
	t_denybotlist *DenyBot;
	t_charlist    RequiredGroup;
	uid_t         UserId;
	gid_t         GroupId;
	t_groups      Groups;
	t_charlist    Volatile;
	t_accesslist  *AccessList;
	t_charlist    ImageReferer;
	char          *ImgRefReplacement;
	t_keyvalue    *EnvirStr;
	t_keyvalue    *Alias;
#ifdef HAVE_SSL
    bool          RequireSSL;
#endif
	bool          PreventXSS;
	bool          PreventSQLi;
	bool          FollowSymlinks;

	struct type_host *next;
} t_host;

typedef struct type_config {
	char         *ServerRoot;
	uid_t        ServerUid;
	gid_t        ServerGid;
	char         *ServerString;
	long         MaxReqSize;
	t_bindlist   *BindHTTP;
	t_groups     Groups;
	t_charlist   CGIextension;
	int          ConnectionsTotal;
	int          ConnectionsPerIP;
	int          TimeForCGI;
	int          TimeForRequest;
	int          MaxKeepAlive;
	bool         EnableTRACE;
	char         *SystemLogfile;
	char         *GarbageLogfile;
	t_accesslist *LogfileMask;
	t_hdirsrc    HomedirSource;
#ifdef HAVE_PLUGIN
	char         *PluginURI;
#endif

#ifdef HAVE_SSL
	t_bindlist   *BindHTTPS;
	char         *ServerKey;
#endif

	t_mimetype   *Mimetype;
	t_host       *first_host;
	t_directory  *Directory;
	t_throttle   *Throttle;
	t_homedir    *Homedir;
	t_CGIhandler *CGIhandler;

	int          BanOnGarbage;
	int          BanOnMaxPerIP;
	int          BanOnFlooding;
	int          BanOnMaxReq;
	int          BanOnSQLi;
	bool         KickOnBan;
	bool         RebanDuringBan;
	int          FloodingCount;
	int          FloodingTime;
	t_accesslist *BanlistMask;

#ifdef HAVE_COMMAND
	t_bindlist   *CommandPort;
	char         *CommandPassword;
#endif
} t_config;

t_config *default_config(void);
void print_configerror(char *configfile, int code);
int check_configuration(t_config *config);
int read_main_configfile(char *file, t_config *config);
t_config *remove_config(t_config *config);
t_homedir *read_homedirs(char *configfile);
t_homedir *remove_homedirs(t_homedir *homedir);
int read_user_configfile(char *file, t_host *host);
#ifdef HAVE_SSL
t_host *get_hostrecord(t_host *host, char *hostname, char *bindname, bool via_ssl);
#else
t_host *get_hostrecord(t_host *host, char *hostname, char *bindname);
#endif
t_throttle *read_throttleconfig(char *configfile);
unsigned short get_throttlespeed(char *type, t_throttle *throttle);
t_throttle *remove_throttleconfig(t_throttle *throttle);

#endif
