#ifndef _SESSION_H
#define _SESSION_H

#ifdef HAVE_SSL
#include <openssl/err.h>
#include <openssl/ssl.h>
#endif
#include "serverconfig.h"
#include "liblist.h"

#define TIMER_OFF -1
#define MAX_CHILD_ID 30000
#define CID_LENGTH 8 /* in bytes, CONNECTION_ID will contain 2 digit hex values */

typedef struct type_headerfield {
	char *data;
	int  value_offset;

	struct type_headerfield *next;
} t_headerfield;

typedef struct type_session {
	t_config       *config;

	int            child_id;
	int            client_socket;
	t_bindlist     *binding;
	bool           socket_open;
	bool           HEAD_request;
	bool           keep_alive;
	int            kept_alive;
	bool           is_CGI_script;
	char           *CGI_handler;
	char           *request, *method, *URI, *vars, *http_version, *body, *file_on_disk;
	long           header_length, content_length, buffer_size, bytes_in_buffer;
	bool           body_copied;
	bool           vars_copied;
	bool           force_quit;
	bool           URI_is_dir;
	bool           accept_gzip;
	bool           encode_gzip;
	t_headerfield  *headerfields;
	long           ip_address;
	char           *mimetype;
	t_host         *host;
	bool           host_copied;
	char           *remote_user;
	t_directory    *Directory;
	bool           handling_error;
	char           *cookie;
	bool           cookie_copied;
	bool           websiteroot_copied;
	char           connection_id[(2 * CID_LENGTH) + 1];

	/* Chunked Transfer-Encoding: send_chunk() in send.c
	 */
	char           *chunkbuffer;
	int            chunksize;

	/* Throttling: send_buffer() in send.c
	 */
	long           throttle;
	long           bytecounter;
	int            throttle_timer;
	bool           part_of_dirspeed;

	/* Flooding protection
	 */
	int            flooding_timer;
	int            flooding_counter;

	/* SSL
	 */
#ifdef HAVE_SSL
	bool           via_ssl;
	SSL            *ssl_data;
#endif
} t_session;

void init_session(t_session *session);
void reset_session(t_session *session);

t_headerfield *parse_headerfields(char *line);
char *get_headerfield(char *key, t_headerfield *headerfields);
void remove_headerfields(t_session *session);

int  get_homedir(t_session *session, char *username);
bool duplicate_host(t_session *session);
void restore_host(t_session *session);
bool is_volatile_object(t_session *session);
int  copy_directory_settings(t_session *session);
void set_environment(t_session *session);
char *file_in_chroot(t_session *session, char *file);
bool client_is_rejected_bot(t_session *session);
void close_socket(t_session *session);

#endif
