#ifndef _CLIENT_H
#define _CLIENT_H

#include "serverconfig.h"
#include "session.h"

#define ca_TOOMUCH_PERIP  -1
#define ca_TOOMUCH_TOTAL  -2
#define ca_BANNED         -3

void init_clientmodule(void);
int  add_client(t_session *session);
void mark_client_for_removal(t_session *session, int delay);
void check_remove_delay_timers(void);
void remove_client(t_session *session, bool free_session);
int  connection_allowed(long ip, int maxperip, int maxtotal);
void disconnect_clients(t_config *config);
void check_flooding(t_config *config);

#ifdef HAVE_COMMAND
void print_clientlist(FILE *fp);
#endif
void kick_client(int id);
void kick_ip(long ip);

int  ban_ip(long ip, int timer, bool kick_on_ban);
void reban_ip(long ip);
void check_banlist(t_config *config);
void unban_ip(long ip);
#ifdef HAVE_COMMAND
void print_banlist(FILE *fp);
#endif

#endif
