#ifndef _COMMAND_H
#define _COMMAND_H

#ifdef HAVE_COMMAND

#include "config.h"
#include "serverconfig.h"

#define cc_DISCONNECT    -1
#define cc_SHUTDOWN      -2
#define cc_UNBAN_CLIENTS  1

typedef struct type_admin {
	int socket;
	FILE *fp;
	bool allowed;
	int timer;

	struct type_admin *next;
} t_admin;

void CC_client_lock(void);
void CC_client_unlock(void);
void CC_admin_lock(void);
void CC_admin_unlock(void);

void init_commandmodule(void);
int add_admin(int sock);
void remove_admin(int sock);
void check_adminlist(void);
t_admin *first_admin(void);
t_admin *next_admin(void);
int handle_admin(t_admin *admin, t_config *config);
void disconnect_admins(void);

#endif

#endif
