#ifndef _LIBCGI_H
#define _LIBCGI_H

#include <stdbool.h>
#include "liblist.h"
#include "serverconfig.h"
#include "session.h"

#define CGI_BUFFER_SIZE      32768

#define rc_END_OF_DATA           2
#define rc_READ_DATA             1
#define rc_OKE                   0
#define rc_NOTHING               0
#define rc_SELECT_ERROR         -1
#define rc_FORCE_QUIT           -2
#define rc_TIMEOUT              -3
#define rc_READ_ERROR           -4

typedef struct type_cgi_info {
	int timer;
	struct timeval select_timeout;

	int to_cgi, from_cgi, cgi_error, highest_fd;

	bool wrap_cgi;

	char *input_buffer, *error_buffer;
	int input_buffer_size, input_len, input_result;
	int error_buffer_size, error_len, error_result;
} t_cgi_info;

int fork_CGI_process(t_session *session, t_cgi_info *cgi_info);
int read_from_CGI_process(t_session *session, t_cgi_info *cgi_info);

#endif
