#ifndef _LIBFS_H
#define _LIBFS_H

#include <stdio.h>
#include <stdbool.h>
#include <sys/types.h>
#include "userconfig.h"

enum t_fsbool { error = -3, not_found, no_access, no, yes };

typedef struct type_filelist {
	char   *name;
	off_t  size;
	time_t time;
	bool   is_dir;

	struct type_filelist *next;
} t_filelist;

long filesize(char *filename);
enum t_fsbool contains_not_allowed_symlink(char *filename, char *webroot);
enum t_fsbool is_directory(char *file);
enum t_fsbool can_execute(char *file, uid_t uid, gid_t gid, t_groups *groups);
void touch_logfile(char *dir, char *file, mode_t mode, uid_t uid, gid_t gid);
int  if_modified_since(int handle, char *datestr);
FILE *fopen_neighbour(char *filename, char *mode, char *neighbour);
t_filelist *read_filelist(char *directory);
t_filelist *sort_filelist(t_filelist *filelist);
t_filelist *remove_filelist(t_filelist *filelist);

#endif
