#ifndef _LIBSTR_H
#define _LIBSTR_H

#include <stdbool.h>

int str2int(const char *str);
char *remove_spaces(char *str);
char *strip_line(char *str);
char *strlower(char *line);
int split_string(const char *str, char **key, char **value, char c);
bool valid_uri(char *uri);
int parse_special_chars(char *line, int length);
int prevent_CMDi(char *line);
int prevent_SQLi(char *line, int length, char **newline);
int prevent_XSS(char *line);
const char *errorstr(int code);
bool decode_base64(char *base64);
char *file_extension(char *filename);
int str_compare(char *str1, char *str2);
int str_ncompare(char *str1, char *str2, int len);
char *str_search(char *haystack, char *needle);
char *str_replace(char *line, char *from, char *to);

#endif
