#ifndef _SERVERCONFIG_H
#define _SERVERCONFIG_H

#include <pthread.h>
#include "mimetype.h"
#include "libfs.h"
#include "liblist.h"
#include "userconfig.h"
#ifdef HAVE_SSL
#include "libssl.h"
#endif

typedef enum { root, part } t_pathmatch;

typedef struct type_cgi_handler {
	char          *handler;
	t_charlist    extension;
	struct type_cgi_handler *next;
} t_cgi_handler;

typedef struct type_throttle {
	char          *filetype;
	unsigned long upload_speed;

	struct type_throttle *next;
} t_throttle;

typedef struct type_binding {
	int           port;
	unsigned long interface;
	char          *name;
#ifdef HAVE_SSL
	bool          use_ssl;
	char          *server_key;
	SSL_CTX       *ssl_context;
#endif

	bool          enable_trace;
	int           max_keepalive;
	long          max_request_size;
	int           time_for_1st_request;
	int           time_for_request;

	int           socket;

	struct type_binding *next;
} t_binding;

typedef struct type_directory {
	char          *path;
	t_pathmatch   path_match;
	char          *cgi_wrap_id;
	t_groups      groups;
	bool          execute_cgi;
	bool          execute_cgiset;
	bool          show_index;
	bool          show_indexSet;
	bool          follow_symlinks;
	bool          follow_symlinksSet;
	char          *passwordfile;
	char          *groupfile;
	t_charlist    required_group;
	t_accesslist  *access_list;
	t_charlist    image_referer;
	char          *imgref_replacement;
	t_keyvalue    *envir_str;

	/* Uploadspeed control
	 */
	int           max_clients;
	int           nr_of_clients;
	long          upload_speed;
	long          session_speed;
	pthread_mutex_t client_mutex;

	struct type_directory *next;
} t_directory;

typedef struct type_host {
	char          *website_root;
	char          *start_file;
	char          *error_handler;
	int           return_code;
	char          *access_logfile;
	FILE          *access_fileptr;
	FILE          **access_fp;
	char          *error_logfile;
	t_charlist    hostname;
	bool          user_websites;
	bool          execute_cgi;
	bool          show_index;
#ifdef HAVE_PLUGIN 
	bool          plugin_active;
#endif
	char          *login_message;
	char          *passwordfile;
	char          *groupfile;
	char          *index_style;
	t_charlist    required_binding;
	t_denybotlist *deny_bot;
	t_charlist    required_group;
	char          *cgi_wrap_id;
	t_groups      groups;
	t_charlist    volatile_object;
	t_accesslist  *access_list;
	t_charlist    image_referer;
	char          *imgref_replacement;
	t_keyvalue    *envir_str;
	t_keyvalue    *alias;
#ifdef HAVE_SSL
    bool          require_ssl;
#endif
	bool          prevent_cmdi;
	bool          prevent_sqli;
	bool          prevent_xss;
	bool          follow_symlinks;

	struct type_host *next;
} t_host;

typedef struct type_config {
	char          *throttle_config;
	char          *mimetype_config;

	char          *server_root;
	uid_t         server_uid;
	gid_t         server_gid;
	t_groups      groups;
	char          *server_string;
	t_binding     *binding;
#ifdef HAVE_SSL
	char          *server_key;
#endif
	t_charlist    cgi_extension;
	int           total_connections;
	int           connections_per_ip;
	int           time_for_cgi;
	char          *system_logfile;
	char          *garbage_logfile;
	t_accesslist  *logfile_mask;
	
#ifdef HAVE_PLUGIN
	char          *plugin_uri;
#endif

	t_mimetype    *mimetype;
	t_host        *first_host;
	t_directory   *directory;
	t_throttle    *throttle;
	t_cgi_handler  *cgi_handler;
	char          *cgi_wrapper;
	bool          wrap_user_cgi;

	int           ban_on_garbage;
	int           ban_on_max_per_ip;
	int           ban_on_flooding;
	int           ban_on_max_request_size;
	int           ban_on_cmdi;
	int           ban_on_sqli;
	int           ban_on_timeout;
	bool          kick_on_ban;
	bool          reban_during_ban;
	int           flooding_count;
	int           flooding_time;
	int           reconnect_delay;
	t_accesslist  *banlist_mask;

#ifdef HAVE_COMMAND
	t_binding     *command_port;
#endif
} t_config;

t_config *default_config(void);
void print_configerror(char *configfile, int code);
int check_configuration(t_config *config);
int read_main_configfile(char *file, t_config *config);
int read_user_configfile(char *file, t_host *host);
t_host *get_hostrecord(t_host *host, char *hostname, t_binding *binding);
int read_throttleconfig(char *configfile, t_throttle **throttle);
unsigned short get_throttlespeed(char *type, t_throttle *throttle);

#endif
