#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pwd.h>
#include <grp.h>
#include "userconfig.h"
#include "libstr.h"
#include "liblist.h"

uid_t parse_userid(char *userid) {
	int id;
	struct passwd *pwd;

	if ((id = str2int(userid)) == -1) {
		if ((pwd = getpwnam(userid)) != NULL) {
			id = (int)pwd->pw_uid;
		} else {
			id = 0;
		}
	}

	return (uid_t)id;
}

static gid_t parse_groupid(char *groupid) {
	int id;
	struct passwd *pwd;

	if ((id = str2int(groupid)) == -1) {
		if ((pwd = getpwnam(groupid)) != NULL) {
			id = (int)pwd->pw_gid;
		} else {
			id = 0;
		}
	}

	return (gid_t)id;
}

gid_t parse_groups(char *gid, t_groups *groups) {
	gid_t retval, *id, test;
	int i, count = 0;
	char *c;

	c = gid;
	while (*c != '\0') {
		if (*c == ',') {
			count++;
			*c = '\0';
		}
		c++;
	}

	if ((retval = parse_groupid(gid)) > (gid_t)0) {
		if (groups != NULL) {
			groups->number = count;
			if (count == 0) {
				return retval;
			}
			groups->array = id = (gid_t*)malloc(groups->number * sizeof(int));
		} else {
			id = &test;
		}

		for (i = 0; i < count; i++) {
			gid = gid + strlen(gid) + 1;
			if ((*id = parse_groupid(gid)) > (gid_t)0) {
				if (groups != NULL) {
					id++;
				}
			} else {
				if (groups != NULL) {
					free(groups->array);
				}
				retval = (gid_t)0;
				break;
			}
		}
	}

	return retval;
}

static bool is_member(char *user, char **group) {
	while (*group != NULL) {
		if (strcmp(user, *group) == 0) {
			return true;
		}
		group++;
	}

	return false;
}

gid_t lookup_group_ids(uid_t uid, t_groups *groups) {
	gid_t gid;
	struct passwd *pwd;
	struct group *grp;
	int size;

	if ((pwd = getpwuid(uid)) != NULL) {
		gid = pwd->pw_gid;

		groups->number = size = 0;
		groups->array = NULL;
		while ((grp = getgrent()) != NULL) {
			if (is_member(pwd->pw_name, grp->gr_mem) && (grp->gr_gid > 0)) {
				if (groups->number == size) {
					size += 10;
					groups->array = (gid_t*)realloc(groups->array, size * sizeof(int));
				}
				*(groups->array + groups->number) = grp->gr_gid;
				groups->number++;
			}
		}
		endgrent();
	} else {
		gid = (gid_t)0;
	}

	return gid;
}

char *lookup_group_names(uid_t uid) {
	char names[257];
	struct passwd *pwd;
	struct group *grp;
	int size;

	if ((pwd = getpwuid(uid)) != NULL) {
		names[256] = '\0';
		snprintf(names, 256, "%d", pwd->pw_gid);

		while ((grp = getgrent()) != NULL) {
			if (is_member(pwd->pw_name, grp->gr_mem) && (grp->gr_gid > 0)) {
				if ((size = strlen(names)) < 250) {
					snprintf(names + size, 256 - size, ",%d", grp->gr_gid);
				} else {
					break;
				}
			}
		}
		endgrent();
		
		return strdup(names);
	} else {
		return NULL;
	}
}
