#ifndef _LOG_H
#define _LOG_H

#include "global.h"
#include "libip.h"
#include "session.h"

void init_log_module(void);
void log_pid(t_config *config, pid_t pid);
void log_string(char *logfile, char *mesg);
void log_system(t_session *session, char *mesg);
void log_error(t_session *session, char *mesg);
void log_request(t_session *session, int code);
void log_garbage(t_session *session);
void log_unban(char *logfile, t_ip_addr *ip_address, unsigned long connect_attempts);
void log_file_error(t_session *session, char *file, char *mesg);
void log_close(t_host *host, bool force_close);

#endif
