#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>
#include "libstr.h"
#include "mimetype.h"

#define MAX_LINE_LENGTH 256
#define MAX_EXT 6

static char *default_mimetype = "text/plain";

/* Read a mimetype configuration file.
 */
int read_mimetypes(char *configfile, t_mimetype **mime) {
	FILE *fp;
	char line[MAX_LINE_LENGTH + 1], *data, *next, *ext;
	bool quit;
	t_mimename *w_mime = NULL;
	t_extension *w_ext = NULL;

	/* Read mimetype configurationfile.
	 */
	if ((fp = fopen(configfile, "r")) == NULL) {
		return -1;
	}

	if ((*mime = (t_mimetype*)malloc(sizeof(t_mimetype))) == NULL) {
		fclose(fp);
		return -1;
	}
	(*mime)->mimename = NULL;
	(*mime)->extension = NULL;

	line[MAX_LINE_LENGTH] = '\0';

	while (fgets(line, MAX_LINE_LENGTH, fp) != NULL) {
		if ((next = data = strdup(line)) == NULL) {
			return -1;
		}
		while (*next != '\0') {
			if (*next == '\t') {
				*next = ' ';
			} else if ((*next == '\r') || (*next == '\n')) {
				*next = '\0';
			}
			next++;
		}
		if ((next = strchr(data, ' ')) != NULL) {
			*next++ = '\0';
			if (w_mime == NULL) {
				if (((*mime)->mimename = w_mime = (t_mimename*)malloc(sizeof(t_mimename))) == NULL) {
					return -1;
				}
			} else {
				if ((w_mime->next = (t_mimename*)malloc(sizeof(t_mimename))) == NULL) {
					return -1;
				}
				w_mime = w_mime->next;
			}
			w_mime->next = NULL;
			w_mime->name = data;

			quit = false;
			while (quit == false) {
				while (*next == ' ') {
					next++;
				}
				if (*next != '\0') {
					ext = next;
					if ((next = strchr(next, ' ')) != NULL) {
						*next++ = '\0';
					} else {
						quit = true;
					}
					if (strlen(ext) <= MAX_EXT) {
						if (w_ext == NULL) {
							if (((*mime)->extension = w_ext = (t_extension*)malloc(sizeof(t_extension))) == NULL) {
								return -1;
							}
						} else {
							if ((w_ext->next = (t_extension*)malloc(sizeof(t_extension))) == NULL) {
								return -1;
							}
							w_ext = w_ext->next;
						}
						w_ext->next = NULL;
						w_ext->mimename = w_mime;
						w_ext->name = ext;
						strlower(w_ext->name);
					}
				} else {
					quit = true;
				}
			}
		}
	}
	fclose(fp);

	return 0;
}

/* Return the mimetype of a file.
 */
char *get_mimetype(char *extension, t_mimetype *mime) {
	char *ext_lower, *result = default_mimetype;
	t_extension *w_ext = NULL;

	/* Convert file extension to mimetype.
	 */ 
	if (extension == NULL) {
		return NULL;
	} else if ((ext_lower = strlower(strdup(extension))) == NULL) {
		return NULL;
	}

	w_ext = mime->extension;
	while (w_ext != NULL) {
		if (strcmp(ext_lower, w_ext->name) == 0) {
			result = w_ext->mimename->name;
			break;
		}
		w_ext = w_ext->next;
	}

	free(ext_lower);

	return result;
}
