#ifndef _LIBSTR_H
#define _LIBSTR_H

#include <sys/types.h>
#include <stdbool.h>

int  str2int(const char *str);
char *remove_spaces(char *str);
char *uncomment(char *str);
char *strlower(char *str);
int  split_string(const char *str, char **key, char **value, char c);
int  split_configline(const char *str, char **key, char **value);
bool valid_uri(char *uri);
int  url_encode(char *str, char **encoded);
void url_decode(char *str);
bool forbidden_chars_present(char *str);
int  prevent_cmdi(char *str);
int  prevent_sqli(char *str, int length, char **newstr);
int  prevent_xss(char *str);
const char *http_error(int code);
bool decode_base64(char *base64);
int  str_replace(char *src, char *from, char *to, char **dst);
bool min_strlen(char *str, int n);
int  header_to_variable(char *header, char *variable, int size);
int  filesize2str(char *buffer, int len, off_t fsize);
int  add_str(char **buffer, int *size, int extra_size, int *len, char *str);

#endif
