/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License. For a copy,
 * see http://www.gnu.org/licenses/gpl-2.0.html.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#ifndef _TOOLKIT_H
#define _TOOLKIT_H

#include <stdbool.h>
#include <regex.h>
#include "liblist.h"

#define UT_ERROR        -1
#define UT_RETURN        0
#define UT_EXIT          1
#define UT_REDIRECT    301
#define UT_DENY_ACCESS 403

#define IU_EXISTS        0
#define IU_ISFILE        1
#define IU_ISDIR         2

typedef enum { ta_match_rewrite, ta_match_goto, ta_match_call, ta_match_return, ta_match_exit, 
               ta_match_expire, ta_match_skip, ta_call, ta_match_deny_access, ta_match_redirect,
               ta_match_fastcgi, ta_match_ban, ta_skip, ta_requesturi} t_toolkit_action;
typedef enum { td_continue, td_return, td_exit } t_toolkit_done;

typedef struct type_toolkit_rule {
	regex_t pattern;
	t_toolkit_action action;
	t_toolkit_done done;
	int match_loop;
	char *parameter;
	int value;

	struct type_toolkit_rule *next;
} t_toolkit_rule;

typedef struct type_url_toolkit {
	char *toolkit_id;
	struct type_toolkit_rule *toolkit_rule;

	struct type_url_toolkit *next;
} t_url_toolkit;

typedef struct type_toolkit_options {
	char *new_url;
	char *website_root;
	char *fastcgi_server;
	int  ban;
	int  expire;
	t_url_toolkit *url_toolkit;
} t_toolkit_options;

t_url_toolkit *find_toolkit(char *toolkit_id, t_url_toolkit *url_toolkit);
bool toolkit_setting(char *key, char *value, t_url_toolkit *toolkit);
bool toolkit_rules_oke(t_url_toolkit *url_toolkit);
void init_toolkit_options(t_toolkit_options *options, char *website_root, t_url_toolkit *toolkit);
int use_toolkit(char *url, char *toolkit_id, t_toolkit_options *options);

#endif
