<?php
	function show_page_overview() {
		global $db, $_output;

		if (($pages = get_pages($db)) === false) {
			$_output->add_tag("result", "Database error.");
		} else {
			$_output->open_tag("overview");
			$_output->open_tag("pages");
			foreach ($pages as $page) {
				$page["visible"] = show_boolean($page["visible"]);
				$_output->record($page, "page");
			}
			$_output->close_tag();
			$_output->close_tag();
		}
	}

	function show_page_form($page) {	
		global $_output, $db;

		$_output->set_xslt_parameter("admin_role_id", ADMIN_ROLE_ID);

		$page["private"] = show_boolean($page["private"]);
		$page["visible"] = show_boolean($page["visible"]);

		$args = array();
		if (isset($page["id"])) {
			$args["id"] = $page["id"];
		}

		$_output->open_tag("edit");
		$_output->open_tag("page", $args);
		$_output->record($page);

		$_output->open_tag("roles");
		if (($roles = get_roles($db)) != false) {
			foreach ($roles as $role) {
				$_output->add_tag("role", $role["name"], array(
					"id" => $role["id"],
					"checked" => show_boolean($page["roles"][$role["id"]])));
			}
		}
		$_output->close_tag();

		$_output->close_tag();
		$_output->close_tag();
	}

	if ($_SERVER["REQUEST_METHOD"] == "POST") {
		if ($_POST["submit_button"] == "Save page") {
			/* Create or update page
			 */
			$_POST["url"] = rtrim($_POST["url"], "/ ");
			if (page_oke($db, $_POST) == false) {
				show_page_form($_POST);
			} else if (isset($_POST["id"]) == false) {
				if (create_page($db, $_POST) === false) {
					$_output->add_message("Database error while creating page.");
					show_page_form($_POST);
				} else {
					$_user->log_action("page ".$_POST["url"]." created");
					show_page_overview();
				}
			} else {
				if (update_page($db, $_POST, $_POST["id"]) === false) {
					$_output->add_message("Database error while updating page.");
					show_page_form($_POST);
				} else {
					$_user->log_action("page ".$_POST["id"]." updated");
					show_page_overview();
				}
			}
		} else if ($_POST["submit_button"] == "Delete page") {
			/* Delete page
			 */
			if (delete_page($db, $_POST["id"]) == false) {
				$_output->add_tag("result", "Database error while deleting page.");
			} else {
				$_user->log_action("page ".$_POST["url"]." deleted");
				show_page_overview();
			}
		} else {
			$_output->add_tag("result", "Huh?");
		}
	} else if ($_page->pathinfo[2] == "new") {
		/* Show the user webform
		 */
		$page = array(
			"url"      => "/",
			"language" => DEFAULT_LANGUAGE,
			"visible"  => 1,
			"roles"    => array());
		show_page_form($page);
	} else if (valid_input($_page->pathinfo[2], VALIDATE_NUMBERS, VALIDATE_NONEMPTY)) {
		/* Show the user webform
		 */
		if (($page = get_page($db, $_page->pathinfo[2])) == false) {
			$_output->add_tag("result", "Page not found.");
		} else {
			show_page_form($page);
		}
	} else {
		/* Show a list of all users
		 */
		show_page_overview();
	}
?>
