<?php
	function show_profile_form($profile) {
		global $_output, $_user;

		$_output->open_tag("edit");
		$_output->add_tag("email", $profile["email"]);
		if ($_user->status == USER_STATUS_CHANGEPWD) {
			$_output->add_tag("cancel", "Logout", array("page" => "logout"));
		} else {
			$_output->add_tag("cancel", "Back", array("page" => "homepage"));
		}
		$_output->close_tag();
	}

	$_output->description = "Profile";
	$_output->keywords = "profile";
	$_output->title = "Profile";

	if ($_SERVER["REQUEST_METHOD"] == "POST") {
		/* Update profile
		 */
		if (profile_oke($_POST) == false) {
			show_profile_form($_POST);
		} else if (update_profile($db, $_POST) === false) {
			$_output->add_tag("result", "Error while updating profile.", array("url" => "profile"));
		} else {
			$_output->add_tag("result", "Profile has been updated.", array("url" => PAGE_AFTER_LOGIN));
			$_user->log_action("profile updated");
		}
	} else {
		$user = array("email" => $_user->email);
		show_profile_form($user);
	}
?>
