<?php
	function get_pages($db) {
		$query = "select id, url, private, title, visible from pages order by url";

		return $db->execute($query);
	}

	function get_page($db, $page_id) {
		if (($page = $db->entry("pages", $page_id)) == false) {
			return false;
		}

		$query = "select role_id,level from page_access where page_id=%d";
		if (($roles = $db->execute($query, $page_id)) === false) {
			return false;
		}

		$page["roles"] = array();
		foreach ($roles as $role) {
			$page["roles"][$role["role_id"]] = $role["level"];
		}

		return $page;
	}

	function get_roles($db) {
		$query = "select id, name from roles order by name";

		return $db->execute($query);
	}

	function page_oke($db, $page) {
		global $_output;

		$result = true;

		if (valid_input(trim($page["url"]), VALIDATE_URL, VALIDATE_NONEMPTY) == false) {
			$_output->add_message("URL is empty or contains invalid characters.");
			$result = false;
		} else if ((strpos($page["url"], "//") !== false) || ($page["url"][0] !== "/")) {
			$_output->add_message("Invalid URL.");
			$result = false;
		}

		if (trim($page["title"]) == "") {
			$_output->add_message("Empty title not allowed.");
			$result = false;
		}

		if (valid_input($page["language"], VALIDATE_NONCAPITALS, 2) == false) {
			$_output->add_message("Invalid language code.");
			$result = false;
		}

		$alias_config = config_file("page_aliases");
		$aliases = array();
		foreach ($alias_config as $line) {
			list($alias) = explode("->", $line);
			array_push($aliases, trim($alias));
		}

		$module = ltrim($page["url"], "/");
		if (in_array($module, config_file("public_pages")) || in_array($module, config_file("private_pages")) || in_array($module, $aliases)) {
			$_output->add_message("URL belongs to a module.");
			$result = false;
		} else {
			$query = "select * from pages where id!=%d and url=%s and language=%s limit 1";
			if (($page = $db->execute($query, $page["id"], $page["url"], $page["language"])) != false) {
				if (count($page) > 0) {
					$_output->add_message("URL belongs to another page.");
					$result = false;
				}
			}
		}

		return $result;
	}

	function save_access($db, $page_id, $roles) {
		if ($db->query("delete from page_access where page_id=%d", $page_id) === false) {
			return false;
		}

		if (is_array($roles) == false) {
			return true;
		}

		foreach ($roles as $role_id => $has_role) {
			if (is_false($has_role) || ($role_id == ADMIN_ROLE_ID)) {
				continue;
			}

			$values = array(
				"page_id" => (int)$page_id,
				"role_id" => (int)$role_id,
				"level"   => 1);
			if ($db->insert("page_access", $values) == false) {
				return false;
			}
		}

		return true;
	}

	function create_page($db, $page) {
		$keys = array("id", "url", "language", "private", "style",
		              "title", "description", "keywords", "content", "visible");
		$page["id"] = null;
		$page["private"] = is_true($page["private"]) ? 1 : 0;
		$page["visible"] = is_true($page["visible"]) ? 1 : 0;

		if ($db->query("begin") == false) {
			return false;
		} else if ($db->insert("pages", $page, $keys) === false) {
			$db->query("rollback");
			return false;
		} else if (save_access($db, $db->last_insert_id, $page["roles"]) == false) {
			$db->query("rollback");
			return false;
		}

		return $db->query("commit") != false;
	}

	function update_page($db, $page, $page_id) {
		$keys = array("url", "language", "private", "style", "title",
		              "description", "keywords", "content", "visible");
		$page["private"] = is_true($page["private"]) ? 1 : 0;
		$page["visible"] = is_true($page["visible"]) ? 1 : 0;

		if ($db->query("begin") == false) {
			return false;
		} else if ($db->update("pages", $page_id, $page, $keys) === false) {
			$db->query("rollback");
			return false;
		} else if (save_access($db, $page_id, $page["roles"]) == false) {
			$db->query("rollback");
			return false;
		}

		return $db->query("commit") != false;
	}


	function delete_page($db, $page_id) {
		$queries = array(
			array("delete from page_access where page_id=%d", $page_id),
			array("delete from pages where id=%d", $page_id));

		return $db->transaction($queries);
	}
?>
