<?php
	function count_users($db) {
		$query = "select count(*) as count from users";

		if (($result = $db->execute($query)) == false) {
			return false;
		}

		return $result[0]["count"];
	}

	function get_all_users($db, $offset, $count) {
		$query = "select * from users u order by username limit %d,%d";

		if (($users = $db->execute($query, $offset, $count)) === false) {
			return false;
		}

		$query = "select * from user_role where user_id=%d and role_id=%d";
		foreach ($users as $i => $user) {
			if (($role = $db->execute($query, $user["id"], ADMIN_ROLE_ID)) === false) {
				return false;
			}
			$users[$i]["is_admin"] = count($role) > 0;
		}

		return $users;
	}

	function get_user($db, $user_id) {
		if (($user = $db->entry("users", $user_id)) == false) {
			return false;
		}

		$query = "select role_id from user_role where user_id=%d";
		if (($roles = $db->execute($query, $user_id)) === false) {
			return false;
		}

		$user["roles"] = array();
		foreach ($roles as $role) {
			array_push($user["roles"], $role["role_id"]);
		}

		return $user;
	}

	function get_all_roles($db) {
		$query = "select * from roles order by name";

		return $db->execute($query);
	}

	function user_has_admin_role($roles) {
		return in_array(ADMIN_ROLE_ID, $roles);
	}

	function user_oke($db, $user) {
		global $_output, $_user;

		$result = true;

		/* Non-admins cannot edit admins
		 */
		if (($_user->is_admin == false) && isset($user["id"])) {
			if (($current = get_user($db, $user["id"])) != false) {
				$_output->add_message("User not found.");
				return false;
			}
			if (in_array(ADMIN_ROLE_ID, $current["roles"])) {
				$_output->add_message("You are not allowed to edit this user.");
				return false;
			}
		}

		if (($user["username"] == "") || ($user["fullname"] == "")) {
			$_output->add_message("The username and full name cannot be empty.");
			$result = false;
		} else if (valid_input($user["username"], VALIDATE_LETTERS.VALIDATE_NUMBERS) == false) {
			$_output->add_message("Invalid characters in username.");
			$result = false;
		} else if (($check = $db->entry("users", $user["username"], "username")) != false) {
			if ($check["id"] != $user["id"]) {
				$_output->add_message("User already exists.");
				$result = false;
			}
		}

		return $result;
	}

	function assign_roles_to_user($db, $user) {
		global $_user;

		if ($db->query("delete from user_role where user_id=%d", $user["id"]) === false) {
			return false;
		}

		if (is_array($user["roles"]) == false) {
			return true;
		}

		foreach ($user["roles"] as $role_id) {
			/* Non-admins cannot assign the admin role
			 */
			if (($_user->is_admin == false) && ($role_id == ADMIN_ROLE_ID)) {
				continue;
			}
			if ($db->query("insert into user_role values (%d, %d)", $user["id"], $role_id) === false) {
				return false;
			}
		}
		
		return true;
	}

	function create_user($db, $user) {
		$keys = array("id", "username", "password", "one_time_key", "status", "fullname", "email");

		$user["id"] = null;
		$user["one_time_key"] = null;
		if (is_false($user["password_hashed"])) {
			$user["password"]  = md5($user["password"]);
		}

		if ($db->query("begin") === false) {
			return false;
		}

		if ($db->insert("users", $user, $keys) === false) {
			$db->query("rollback");
			return false;
		}
		$user["id"] = $db->last_insert_id;

		if (assign_roles_to_user($db, $user) === false) {
			$db->query("rollback");
			return false;
		}

		return $db->query("commit") !== false;
	}

	function update_user($db, $user) {
		global $_user;

		$keys = array("username", "fullname", "email");
		if ($user["password"] != "") {
			array_push($keys, "password");
			if (is_false($user["password_hashed"])) {
				$user["password"]  = md5($user["password"]);
			}
		}
		if (is_array($user["roles"]) == false) {
			$user["roles"] = array();
		}
		if ($_user->id != $user["id"]) {
			array_push($keys, "status");
		} else if (($old = get_user($db, $user["id"])) == false) {
			return false;
		} else if (in_array(ADMIN_ROLE_ID, $old["roles"]) && (in_array(ADMIN_ROLE_ID, $user["roles"]) == false)) {
			array_unshift($user["roles"], ADMIN_ROLE_ID);
		}

		if ($db->query("begin") === false) {
			return false;
		}

		if (assign_roles_to_user($db, $user) === false) {
			$db->query("rollback");
			return false;
		}

		if ($db->update("users", $user["id"], $user, $keys) === false) {
			$db->query("rollback");
			return false;
		}

		return $db->query("commit") !== false;
	}

	function delete_user($db, $user_id) {
		global $_user;

		if ($user_id == $_user->id) {
			return false;
		}

		$queries = array(
			array("delete from user_role where user_id=%d", $user_id),
			array("delete from users where id=%d", $user_id));

		return $db->transaction($queries);
	}
?>
