<?php
	function get_information($db, $begin, $end, $filter_hostname, $filter_webserver) {
		$query = "select b.browser, count(*) as count ".
		         "from requests r, user_agents u, user_agent_browser b, user_agent_os o ".
		         "where r.user_agent_id=u.id and u.browser_id=b.id and u.os_id=o.id ".
				 "and timestamp>%s and timestamp<%s";

		$filter_args = array();
		if ($filter_hostname != 0) {
			$query .= " and r.hostname_id=%d";
			array_push($filter_args, $filter_hostname);
		}
		if ($filter_webserver != 0) {
			$query .= " and r.webserver_id=%d";
			array_push($filter_args, $filter_webserver);
		}
		$query .= " group by browser order by count desc";

		return $db->execute($query, $begin, $end, $filter_args);
	}
?>
