<?php
	/* public/index.php
	 *
	 * Copyright (C) by Hugo Leisink <hugo@leisink.net>
	 * This file is part of the Banshee PHP framework
	 * http://www.hiawatha-webserver.org/banshee
	 *
	 * Don't change this file, unless you know what you are doing.
	 */

	require("../libraries/settings.php");
	require("../libraries/security.php");
	require("../libraries/general.php");

	/* Check for IP bans
	 */
	check_ip_bans(BANNED_IPS);

	/* Abort on dangerous PHP settings
	 */
	check_PHP_setting("register_globals", 0);
	check_PHP_setting("allow_url_include", 0);

	/* Secure the submitted data
	 */
	$superglobals = array(&$_REQUEST, &$_GET, &$_POST, &$_COOKIE);
	foreach ($superglobals as &$superglobal) {
		$superglobal = secure_input($superglobal);
	}

	/* Start PHP session
	 */
	session_name(SESSION_NAME);
	session_start();

	/* Load core modules
	 */
	$db      = new MySQLi_connection(DB_HOSTNAME, DB_DATABASE, DB_USERNAME, DB_PASSWORD);
	$_user   = new user($db);
	$_page   = new page($db, $_user);
	$_output = new output($db, $_page);
	#$_language = new language($db, $_page, $_output);

	/* Include the model
	 */
	if (file_exists($file = "../models/".$_page->module.".php")) {
		include($file);
	}

	$_output->open_tag("output", array("url" => $_page->url));
	$_output->add_tag("banshee_version", BANSHEE_VERSION);
	$_output->add_tag("monitor_version", MONITOR_VERSION);
	$_output->add_tag("website_url", $_SERVER["SERVER_NAME"]);

	/* Page information
	 */
	$_output->add_tag("page", $_page->page, array(
		"module" => $_page->module,
		"type"   => $_page->type));

	/* User information
	 */
	if ($_user->logged_in) {
		$params = array("id" => $_user->id, "admin" => show_boolean($_user->is_admin));
		$_output->add_tag("user", $_user->fullname, $params);
	}

	/* Main menu
	 */
	if (is_true(WEBSITE_ONLINE) && $_user->logged_in) {
		if ($_output->fetch_from_cache("menu") == false) {
			$_output->start_caching("menu");
			$menu = new menu($db, $_output);
			$menu->to_output(0, 2, $_page->page);
			$_output->stop_caching();
		}
	}

	/* Stylesheet
	 */
	$_output->add_css($_page->module.".css");

	/* Old browser notification
	*/
	if (preg_match("/MSIE [123456]/", $_SERVER["HTTP_USER_AGENT"]) > 0) {
		if ($_SESSION["old_browser"] != 1) {
			$_SESSION["old_browser"] = 1;
			$_output->add_css("includes/old_browser.css");
			$_output->add_tag("old_browser");
		}
	}

	/* Include the controller
	 */
	$_output->open_tag("content", array("layout" => $_output->layout));
	if (file_exists($file = "../controllers/".$_page->module.".php")) {
		include($file);
	}

	/* Object-oriented page
	 */
	$class = str_replace("/", "_", $_page->module)."_controller";
	if (class_exists($class)) {
		$controller = new $class($db, $_user, $_page, $_output);
		$controller->execute();
	}

	$_output->close_tag();

	$_output->close_tag();

	/* Output content
	 */
	$_output->generate($_GET["output"], $_page->view);
?>
