<?xml version="1.0" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:include href="includes/banshee.xslt" />

<!--
//
//  Actions template
//
//-->
<xsl:template match="actions">
<xsl:for-each select="webserver">
<fieldset class="webserver">
<legend><xsl:value-of select="@name" /></legend>
<xsl:for-each select="action">
<div class="action">
<div class="type"><xsl:value-of select="." /></div>
<div class="timestamp"><xsl:value-of select="@timestamp" /></div>
</div>
</xsl:for-each>
</fieldset>
</xsl:for-each>
</xsl:template>

<!--
//
//  Result template
//
//-->
<xsl:template match="result">
<p><xsl:value-of select="." /></p>
<xsl:choose>
	<xsl:when test="@url">
		<xsl:call-template name="redirect"><xsl:with-param name="url" select="@url" /></xsl:call-template>
	</xsl:when>
	<xsl:otherwise>
		<xsl:call-template name="redirect" />
	</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!--
//
//  Content template
//
//-->
<xsl:template match="content">
<h1>Actions</h1>
<xsl:apply-templates select="actions" />
<xsl:apply-templates select="result" />
</xsl:template>

</xsl:stylesheet>
