<?xml version="1.0" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- 
//
//  Include Google Analytics code
//
//-->
<xsl:template match="google_analytics">
<script type="text/javascript">
&lt;!--
	var gaJsHost = (("https:" == document.location.protocol) ? "https://ssl." : "http://www.");
	document.write(unescape("%3Cscript src='" + gaJsHost + "google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E"));
//-->
</script>
<script type="text/javascript">
&lt;!--
	if (typeof(_gat) != "undefined") {
		var pageTracker = _gat._getTracker("<xsl:value-of select="." />");
		pageTracker._initData();
		pageTracker._trackPageview();
	}
//-->
</script>
</xsl:template>

<!-- 
//
//  Redirect page
//
//-->
<xsl:template name="redirect">
<xsl:param name="url" select="/output/page" />
<xsl:param name="seconds">3</xsl:param>
<xsl:param name="text">yes</xsl:param>

<xsl:if test="$text='yes'">
<p>Click <a href="/{$url}">here</a> to continue or wait <xsl:value-of select="$seconds" /> seconds to be redirected.</p>
</xsl:if>
<script type="text/javascript">
&lt;!--
	function redirect() {
		document.location = "/<xsl:value-of select="$url" />";
	}

	setTimeout("redirect()", <xsl:value-of select="$seconds" />000);
//-->
</script>
</xsl:template>

<!-- 
//
//  Show messages
//
//-->
<xsl:template name="show_messages">
<xsl:if test="/output/messages/message">
	<div class="warnings">
	<xsl:for-each select="/output/messages/message">
		<div class="warning"><xsl:value-of select="." /></div>
	</xsl:for-each>
	</div>
</xsl:if>
</xsl:template>

<!-- 
//
//  Show website error
//
//-->
<xsl:template match="website_error">
<xsl:choose>
	<xsl:when test=".=200">
		Although no error occurred, you ended up at the error page.
	</xsl:when>
	<xsl:when test=".=401">
		You are not authorized to view this page.
	</xsl:when>
	<xsl:when test=".=403">
		You are not allowed to view this page.
	</xsl:when>
	<xsl:when test=".=404">
		The requested page could not be found.
	</xsl:when>
	<xsl:otherwise>
		An internal error has occurred.
	</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!--
//
//  Show old-browser message
//
//-->
<xsl:template match="old_browser">
<div id="old_browser" class="old_browser">
<div onClick="javascript:document.getElementById('old_browser').style.display = 'none'" class="close">X</div>
<h2>Did you know that your Internet browser is out of date?</h2>
<p>To get the best possible experience using the Internet, I recommend that you upgrade to a new version of Internet Explorer or another web browser. A list of available browsers can be found below.</p>
<p>Just click on one of the icons to get to the download page.</p>
<div class="browser_icon"><a href="http://www.microsoft.com/ie8" target="_blank"><img src="/images/browsers/ie.gif" alt="IE" /></a>Internet Explorer</div>
<div class="browser_icon"><a href="http://www.getfirefox.com/" target="_blank"><img src="/images/browsers/firefox.gif" alt="Firefox" /></a>Firefox</div>
<div class="browser_icon"><a href="http://www.apple.com/safari" target="_blank"><img src="/images/browsers/safari.gif" alt="Safari" /></a>Safari</div>
<div class="browser_icon"><a href="http://www.opera.com/" target="_blank"><img src="/images/browsers/opera.gif" alt="Opera" /></a>Opera</div>
<div class="browser_icon"><a href="http://www.google.com/chrome" target="_blank"><img src="/images/browsers/chrome.gif" alt="Chrome" /></a>Chrome</div>
</div>
</xsl:template>

</xsl:stylesheet>
