<?php
	if (($actions = get_actions($db)) === false) {
		$_output->add_tag("result", "Database error.");
		return;
	}

	$webserver = null;
	$_output->open_tag("actions");
	foreach ($actions as $action) {
		if ($action["name"] != $webserver) {
			if ($webserver !== null) {
				$_output->close_tag();
			}
			$webserver = $action["name"];
			$_output->open_tag("webserver", array("name" => $webserver));
		}

		$timestamp = date("j F Y, H:i:s", $action["timestamp"]);
		$_output->add_tag("action", $action["action"], array("timestamp" => $timestamp));
	}
	if ($webserver !== null) {
		$_output->close_tag();
	}
	$_output->close_tag();
?>
