<?php
	$menu = array(
		"Authentication / authorization" => array(
			"Users"         => array("admin/user", "users.png"),
			"Roles"         => array("admin/role", "roles.png"),
			"Access"        => array("admin/access", "access.png")),
		"Content" => array(
			"Files"         => array("admin/file", "files.png"),
			"Hostnames"     => array("admin/hostname", "hostname.gif"),
			"Menu"          => array("admin/menu", "menu.png"),
			"Pages"         => array("admin/page", "page.png"),
			"Webservers"    => array("admin/webserver", "webserver.png")),
		"Support and testing" => array(
			"Action log"    => array("admin/action", "action.png"),
			"User switch"   => array("admin/switch", "switch.png")));

	$access_list = page_access_list($db);

	$_output->open_tag("menu");
	foreach ($menu as $text => $section) {
		$_output->open_tag("section", array("text" => $text));
		foreach ($section as $text => $info) {
			list($page, $icon) = $info;
			if (isset($access_list[$page])) {
				$access = show_boolean($access_list[$page] > 0);
			} else {
				$access = show_boolean(true);
			}
			$_output->add_tag("entry", $page, array(
				"text" => $text,
				"access" => $access,
				"icon" => $icon));
		}
		$_output->close_tag();
	}
	$_output->close_tag();
?>
