<?php
	if (($users = get_all_users($db)) === false) {
		$_output->add_tag("result", "Database error.");
	} else if (($modules = get_private_modules($db)) === false) {
		$_output->add_tag("result", "Database error.");
	} else if (($pages = get_private_pages($db)) === false) {
		$_output->add_tag("result", "Database error.");
	} else if (($roles = get_all_roles($db)) === false) {
		$_output->add_tag("result", "Database error.");
	} else {
		$_output->open_tag("overview");

		/* Roles
		 */
		$_output->open_tag("roles");
		foreach ($roles as $role) {
			$_output->add_tag("role", $role["name"]);
		}
		$_output->close_tag();

		/* Users
		 */
		$_output->open_tag("users");
		foreach ($users as $user) {
			$_output->open_tag("user", array("name" => $user["username"]));
			foreach ($roles as $role) {
				$_output->add_tag("role", in_array($role["id"], $user["roles"]) ? YES : NO);
			}
			$_output->close_tag();
		}
		$_output->close_tag();

		/* Modules
		 */
		$_output->open_tag("modules");
		foreach ($modules as $module) {
			$_output->open_tag("module", array("url" => $module));
			foreach ($roles as $role) {
				$_output->add_tag("access", $role[$module]);
			}
			$_output->close_tag();
		}
		$_output->close_tag();

		/* Pages
		 */
		$_output->open_tag("pages");
		foreach ($pages as $page) {
			$_output->open_tag("page", array("url" => $page["url"]));
			foreach ($roles as $role) {
				$level = $page["access"][$role["id"]];
				$_output->add_tag("access", isset($level) ? $level : 0);
			}
			$_output->close_tag();
		}
		$_output->close_tag();

		$_output->close_tag();
	}
?>
