<?php
	if (valid_input($_page->pathinfo[2], VALIDATE_NUMBERS, VALIDATE_NONEMPTY) == false) {
		$offset = 0;
	} else {
		$offset = $_page->pathinfo[2];
	}

	if (isset($_SESSION["admin_actionlog_size"]) == false) {
		$_SESSION["admin_actionlog_size"] = get_log_size();
	}

	$paging = new pagination($_output, "admin_actionlog", ADMIN_PAGE_SIZE, $_SESSION["admin_actionlog_size"]);

	if (($log = get_action_log($paging->offset, $paging->size)) === false) {
		$_output->add_tag("result", "Error reading action log.");
		return;
	}

	$users = array($_user->id => $_user->username);

	$_output->open_tag("log");

	$_output->open_tag("list");
	foreach ($log as $entry) {
		$user_id = $entry["user_id"];

		if (isset($users[$user_id]) == false) {
			if (($user = get_user($db, $user_id)) !== false) {
				$users[$user_id] = $user["username"];
			}
		}

		$entry["username"] = isset($users[$user_id]) ? $users[$user_id] : "-";

		$_output->record($entry, "entry");
	}
	$_output->close_tag();

	$paging->show_browse_links();

	$_output->close_tag();
?>
