<?php
	function show_menu_form($menu_id, $menu) {
		global $db, $_output;

		$_output->open_tag("edit");

		if (($parent = get_menu($db, $menu_id)) != false) {
			$_output->add_tag("parent", $parent["text"], array("id" => $parent["parent_id"]));
		}

		$_output->open_tag("menu", array("id" => $menu_id));
		$max_id = 0;
		foreach ($menu as $item) {
			unset($item["parent_id"]);
			$_output->record($item, "item");
			if ($item["id"] > $max_id) {
				$max_id = $item["id"];
			}
		}
		$_output->close_tag();
		$_output->add_tag("max_menu_id", $max_id + 1);
		$_output->close_tag();
	}

	$url = array("url" => "admin/menu");

	if ($_SERVER["REQUEST_METHOD"] == "POST") {
		/* Update menu
		 */
		if (menu_oke($db, $_POST) == false) {
			foreach ($_POST["menu"] as $id => $value) {
				$_POST["menu"][$id]["id"] = $id;
			}
			show_menu_form($_POST["menu_id"], $_POST["menu"]);
		} else if (update_menu($db, $_POST["menu_id"], $_POST["menu"]) == false) {
			$_output->add_tag("result", "Error while updating menu.", $url);
		} else {
			$_output->add_tag("result", "The menu has been updated.", array("url" => "admin/menu/".$_POST["menu_id"]));
			$_output->remove_from_cache("menu");
			$_user->log_action("menu ".$_POST["menu_id"]." updated");
		}
	} else {
		/* Show menu
		 */
		if (valid_input($_page->pathinfo[2], VALIDATE_NUMBERS, VALIDATE_NONEMPTY) == false) {
			$menu_id = 0;
		} else if (($menu_id = (int)$_page->pathinfo[2]) != 0) {
			if (($parent = get_menu($db, $menu_id)) == false) {
				$_output->add_tag("result", "Menu not found.", $url);
				return;
			}
		}

		if (($menu = get_menu_items($db, $menu_id)) === false) {
			$_output->add_tag("result", "Database error!", $url);
		} else {
			show_menu_form($menu_id, $menu);
		}
	}
?>
