<?php
	function show_role_overview() {
		global $db, $_output;

		if (($roles = get_all_roles($db)) === false) {
			$_output->add_tag("result", "Database error.");
		} else {
			$_output->open_tag("overview");

			$_output->open_tag("roles");
			foreach ($roles as $role) {
				$_output->add_tag("role", $role["name"], array("id" => $role["id"], "users" => $role["users"]));
			}
			$_output->close_tag();

			$_output->close_tag();
		}
	}

	function show_role_form($role) {
		global $_user, $db, $_output;

		if (isset($role["id"]) == false) {
			$editable = true;
			$params = array();
		} else {
			$editable = ($role["id"] != ADMIN_ROLE_ID);
			$params = array("id" => $role["id"]);
		}

		if (($pages = get_restricted_pages($db)) == false) {
			$_output->add_tag("Database error.");
			return;
		}
		sort($pages);

		$_output->set_xslt_parameter("admin_role_id", ADMIN_ROLE_ID);

		$_output->open_tag("edit");

		$_output->add_tag("role", $role["name"], $params);
		$_output->open_tag("pages");
		foreach ($pages as $page) {
			$_output->add_tag("page", $page, array("checked" => show_boolean($role[$page])));
		}
		$_output->close_tag();

		$_output->open_tag("members");
		if (($users = get_role_members($db, $role["id"])) !== false) {
			foreach ($users as $user) {
				$_output->add_tag("member", $user["fullname"], array("id" => $user["id"]));
			}
		}
		$_output->close_tag();

		$_output->close_tag();
	}

	if ($_SERVER["REQUEST_METHOD"] == "POST") {
		if ($_POST["submit_button"] == "Save role") {
			/* Create or update an role
			 */
			if (role_oke($_POST) == false) {
				show_role_form($_POST);
			} else if (isset($_POST["id"]) == false) {
				if (create_role($db, $_POST) === false) {
					$_output->add_message("Database error while creating role.");
					show_role_form($_POST);
				} else {
					$_user->log_action("role ".$db->last_insert_id." created");
					show_role_overview();
				}
			} else {
				if (update_role($db, $_POST) === false) {
					$_output->add_message("Database error while updating role.");
					show_role_form($_POST);
				} else {
					$_user->log_action("role ".$_POST["id"]." updated");
					show_role_overview();
				}
			}
		} else if ($_POST["submit_button"] == "Delete role") {
			/* Delete a role
			 */
			if ($_POST["id"] == ADMIN_ROLE_ID) {
				$_output->add_tag("result", "This role cannot be deleted.");
			} else if (delete_role($db, $_POST["id"]) == false) {
				$_output->add_tag("result", "Database error while deleting role.");
			} else {
				$_user->log_action("role ".$_POST["id"]." deleted");
				show_role_overview();
			}
		} else {
			$_output->add_tag("result", "Huh?");
		}
	} else if (valid_input($_page->pathinfo[2], VALIDATE_NUMBERS, VALIDATE_NONEMPTY)) {
		/* Show the role webform
		 */
		if (($role = get_role($db, $_page->pathinfo[2])) != false) {
			show_role_form($role);
		} else {
			$_output->add_tag("result", "Role not found.");
		}
	} else if ($_page->pathinfo[2] == "new") {
		/* Show the role webform
		 */
		$role = array("profile" => true);
		show_role_form($role);
	} else {
		/* Show a list of all roles
		 */
		show_role_overview();
	}
?>
