<?php
	if (isset($_SESSION["user_switch"])) {
		/* User switch already active
		 */
		$_output->add_tag("result", "User switch already active.", array("url" => START_PAGE));
	} else if ($_SERVER["REQUEST_METHOD"] == "POST") {
		/* Switch user
		 */
		if ($_POST["user_id"] == $_user->id) {
			$_output->add_tag("result", "Can't change to yourself.");
		} else if (($_POST["user_id"] == "0") || (get_user($db, $_POST["user_id"]) === false)) {
			$_output->add_tag("result", "User doesn't exist.");
		} else {
			$_user->log_action("switched to user_id ".$_POST["user_id"]);
			$_SESSION["user_switch"] = $_SESSION["user_id"];
			$_SESSION["user_id"] = (int)$_POST["user_id"];
			$_output->add_tag("result", "User switch successfull.", array("url" => START_PAGE));
		}
	} else {
		/* Show user list
		 */
		if (($users = get_users($db)) === false) {
			$_output->add_tag("result", "Database error");
		} else {
			$_output->open_tag("users");
			foreach ($users as $user) {
				$_output->record($user, "user");
			}
			$_output->close_tag();
		}
	}
?>
