<?php
	function show_user_overview() {
		global $db, $_output, $_user;

		if (($user_count = count_users($db)) === false) {
			$_output->add_tag("result", "Database error.");
			return;
		}

		$paging = new pagination($_output, "admin_users", ADMIN_PAGE_SIZE, $user_count);

		if ((($users = get_all_users($db, $paging->offset, $paging->size)) === false) || (($roles = get_all_roles($db)) === false)) {
			$_output->add_tag("result", "Database error.");
			return;
		}

		$status = array("Disabled", "Change password", "Active");

		$_output->open_tag("overview");

		$_output->open_tag("users");
		foreach ($users as $user) {
			/* Non-admins cannot edit admins
			 */
			if (($_user->is_admin == false) && $user["is_admin"]) {
				continue;
			}

			$user["status"] = $status[$user["status"]];

			$_output->open_tag("user", array("id" => $user["id"]));
			$_output->add_tag("username", $user["username"]);
			$_output->add_tag("fullname", $user["fullname"]);
			$_output->add_tag("email", $user["email"]);
			$_output->add_tag("status", $user["status"]);
			$_output->close_tag();
		}
		$_output->close_tag();

		$paging->show_browse_links();

		$_output->close_tag();
	}

	function show_user_form($user) {
		global $_user, $db, $_output;

		if (isset($user["roles"]) == false) {
			$user["roles"] = array();
		}

		if (($roles = get_all_roles($db)) == false) {
			$_output->add_tag("result", "Database error.");
			return;
		}

		/* Non-admins cannot edit admins
		 */
		if (($_user->is_admin == false) && in_array(ADMIN_ROLE_ID, $user["roles"])) {
			$_output->add_tag("result", "You are not allowed to edit this user.");
			return;
		}

		$_output->open_tag("edit");

		$_output->open_tag("status");
		$status = array(
			USER_STATUS_DISABLED =>  "Disabled",
			USER_STATUS_CHANGEPWD => "Change password",
			USER_STATUS_ACTIVE =>    "Active");
		foreach ($status as $id => $stat) {
			$_output->add_tag("status", $stat, array("id" => $id));
		}
		$_output->close_tag();

		$_output->record($user, "user");
		$_output->open_tag("roles");
		foreach ($roles as $role) {
			/* Non-admins cannot assign the admin role
			 */
			if (($_user->is_admin == false) && ($role["id"] == ADMIN_ROLE_ID)) {
				continue;
			}

			$checked = in_array($role["id"], $user["roles"]);
			$enabled = ($_user->id != $user["id"]) || ($role["id"] != ADMIN_ROLE_ID); /* Don't disable yourself */
			
			$_output->add_tag("role", $role["name"], array(
				"id" => $role["id"],
				"checked" => show_boolean($checked),
				"enabled" => show_boolean($enabled)));
		}
		$_output->close_tag();
		$_output->close_tag();
	}

	if ($_SERVER["REQUEST_METHOD"] == "POST") {
		if ($_POST["submit_button"] == "Save user") {
			/* Create or update an user
			 */
			if (user_oke($db, $_POST) == false) {
				show_user_form($_POST);
			} else if (isset($_POST["id"]) === false) {
				if (create_user($db, $_POST) === false) {
					$_output->add_message("Database error while creating user.");
					show_user_form($_POST);
				} else {
					$_user->log_action("user ".$db->last_insert_id(count($_POST["roles"]))." created");
					show_user_overview();
				}
			} else {
				if (update_user($db, $_POST) === false) {
					$_output->add_message("Database error while updating user.");
					show_user_form($_POST);
				} else {
					$_user->log_action("user ".$_POST["id"]." updated");
					show_user_overview();
				}
			}
		} else if ($_POST["submit_button"] == "Delete user") {
			/* Delete an user
			 */
			if (delete_user($db, $_POST["id"]) == false) {
				$_output->add_tag("result", "Database error while deleting user.");
			} else {
				$_user->log_action("user ".$_POST["id"]." deleted");
				show_user_overview();
			}
		} else {
			/* Invalid submit
			 */
			$_output->add_tag("result", "Huh?");
		}
	} else if ($_page->pathinfo[2] == "new") {
		/* Show the user webform
		 */
		$user = array(
			"role_ids" => array(ADMIN_ROLE_ID + 1),
			"status" => USER_STATUS_CHANGEPWD,
			"roles" => array());
		show_user_form($user);
	} else if (valid_input($_page->pathinfo[2], VALIDATE_NUMBERS, VALIDATE_NONEMPTY)) {
		/* Show the user webform
		 */
		if (($user = get_user($db, $_page->pathinfo[2])) == false) {
			$_output->add_tag("result", "User not found.");
		} else {
			show_user_form($user);
		}
	} else {
		/* Show a list of all users
		 */
		show_user_overview();
	}
?>
