<?php
	define("PIXELS", 580);

	$filter = new filter($db, $_output);
	$filter->to_output("requests");

	$begin = date("Y-m-d", strtotime("-".MONITOR_DAYS." days"));
	$end = date("Y-m-d", strtotime("tomorrow"));

	if (($info = get_information($db, $begin, $end, $filter->hostname, $filter->webserver)) === false) {
		$_output->add_tag("result", "Database error.");
		return;
	}

	$max = 0;
	foreach ($info as $item) {
		if ($item["count"] > $max) {
			$max = $item["count"];
		}
	}

	$_output->add_tag("max", $max);

	$_output->open_tag("info", array("label" => "Web browser with Operating System"));
	foreach ($info as $item) {
		$count = $max == 0 ? 0 : (int)(PIXELS * $item["count"] / $max);
		$_output->add_tag("item", $item["info"], array("count" => $count));
	}
	$_output->close_tag();
?>
