<?php
	/* Webserver
	 */
	$webservers = get_webservers($db);
	foreach ($webservers as $webserver) {
		$webserver["ssl"] = show_boolean($webserver["ssl"]);
		$webserver["active"] = show_boolean($webserver["active"]);

		$_output->record($webserver, "webserver");
	}

	/* Alerts
	 */
	$period = ALERT_HOURS." hours";

	$_output->add_tag("period", $period);
	$timestamp = date("Y-m-d H:i:s", strtotime("-".$period));

	/* Exploit attempts
	 */
	$_output->open_tag("list", array("title" => "Top exploit attempts"));
	$list = get_top_exploit_attempts($db, $timestamp);
	foreach ($list as $item) {
		$_output->add_tag("item", $item["hostname"], array("count" => $item["attempts"]));
	}
	$_output->close_tag();

	/* Bans
	 */
	$_output->open_tag("list", array("title" => "Top bans"));
	$list = get_top_bans($db, $timestamp);
	foreach ($list as $item) {
		$_output->add_tag("item", $item["hostname"], array("count" => $item["bans"]));
	}
	$_output->close_tag();

	/* Forbiddens
	 */
	$_output->open_tag("list", array("title" => "Top Forbiddens"));
	$list = get_top_forbiddens($db, $timestamp);
	foreach ($list as $item) {
		$_output->add_tag("item", $item["hostname"], array("count" => $item["forbidden"]));
	}
	$_output->close_tag();

	/* Not founds
	 */
	$_output->open_tag("list", array("title" => "Top Not Founds"));
	$list = get_top_not_founds($db, $timestamp);
	foreach ($list as $item) {
		$_output->add_tag("item", $item["hostname"], array("count" => $item["not_found"]));
	}
	$_output->close_tag();

	/* Internal Errors
	 */
	$_output->open_tag("list", array("title" => "Top Internal Errors"));
	$list = get_top_internal_errors($db, $timestamp);
	foreach ($list as $item) {
		$_output->add_tag("item", $item["hostname"], array("count" => $item["errors"]));
	}
	$_output->close_tag();
?>
