<?php
	define("PIXELS", 200);

	$filter = new filter($db, $_output);
	$filter->to_output("host_statistics");

	$begin = date("Y-m-d", strtotime("-".MONITOR_DAYS." days"));
	$end = date("Y-m-d", strtotime("tomorrow"));

	if (($statistics = get_statistics($db, $begin, $end, $filter->hostname, $filter->webserver)) === false) {
		$db->output("result", "Database error.");
		return;
	}

	$graphs = array(
		"requests"              => "Requests",
		"bytes_sent"            => "Bytes sent",
		"bans"                  => "Clients banned",
		"exploit_attempts"      => "Exploit attempts",
		"result_forbidden"      => "Result: 403 Forbidden",
		"result_not_found"      => "Result: 404 Not Found",
		"result_internal_error" => "Result: 500 Internal Server Error");

	$_output->open_tag("graphs", array(
		"begin" => date("j F Y", strtotime($begin)),
		"end"   => date("j F Y", strtotime($end) - DAY)));

	foreach ($graphs as $key => $label) {
		$max = 0;
		foreach ($statistics as $day => $record) {
			if ($record[$key] > $max) {
				$max = $record[$key];
			}
		}

		$_output->open_tag("graph", array(
			"label" => $label,
			"max"   => readable_number($max)));

		foreach ($statistics as $day => $record) {
			$value = ($max == 0) ? 0 : (int)(PIXELS * $record[$key] / $max) + 1;
			$day = date("j F", strtotime($day));
			$_output->add_tag("day", $value, array(
				"label" => $day,
				"count" => readable_number($record[$key])));
		}

		$_output->close_tag();
	}

	$_output->close_tag();
?>
