<?php
	define("PIXELS", 730);

	$filter = new filter($db, $_output);
	$filter->to_output("requests");

	$begin = date("Y-m-d", strtotime("-".MONITOR_DAYS." days"));
	$end = date("Y-m-d", strtotime("tomorrow"));

	if (($info = get_information($db, $begin, $end, $filter->hostname, $filter->webserver)) === false) {
		$_output->add_tag("result", "Database error.");
		return;
	}

	$max = 0;
	foreach ($info as $browser) {
		if ($browser["count"] > $max) {
			$max = $browser["count"];
		}
	}
	$_output->add_tag("max", $max);

	/* Operating Systems
	 */
	$_output->open_tag("info", array("label" => "Operating Systems"));
	foreach ($info as $os) {
		$count = $max == 0 ? 0 : (int)(PIXELS * $os["count"] / $max);
		$_output->add_tag("item", $os["os"], array("count" => $count));
	}
	$_output->close_tag();
?>
