<?php
	define("PIXELS", 730);

	$filter = new filter($db, $_output);
	$filter->to_output("requests");

	$begin = date("Y-m-d", strtotime("-".MONITOR_DAYS." days"));
	$end = date("Y-m-d", strtotime("tomorrow"));

	if (($origins = get_origins($db, $begin, $end, $filter->hostname, $filter->webserver)) === false) {
		$_output->add_tag("Database error.\n");
		return;
	}

	$max = 0;
	foreach ($origins as $origin) {
		if ($origin["count"] > $max) {
			$max = $origin["count"];
		}
	}

	$_output->open_tag("origins", array("max" => $max));
	foreach ($origins as $origin) {
		$count = $max == 0 ? 0 : (int)(PIXELS * $origin["count"]/ $max);
		$_output->add_tag("origin", $origin["country"], array("count" => $count));
	}
	$_output->close_tag();
?>
