<?php
	define("PIXELS", 730);

	$filter = new filter($db, $_output);
	$filter->to_output("requests");

	$begin = date("Y-m-d", strtotime("-".MONITOR_DAYS." days"));
	$end = date("Y-m-d", strtotime("tomorrow"));

	if (($info = get_information($db, $begin, $end, $filter->hostname, $filter->webserver)) === false) {
		$_output->add_tag("result", "Database error.");
		return;
	}

	$max = 0;
	foreach ($info as $browser) {
		if ($browser["count"] > $max) {
			$max = $browser["count"];
		}
	}
	$_output->add_tag("max", $max);

	/* Browsers
	 */
	$_output->open_tag("info");
	foreach ($info as $browser) {
		$count = $max == 0 ? 0 : (int)(PIXELS * $browser["count"] / $max);
		$_output->add_tag("item", $browser["browser"], array("count" => $count));
	}
	$_output->close_tag();
?>
