<?php
	function get_all_users($db) {
		$query = "select id,username from users order by username";
		if (($users = $db->execute($query)) == false) {
			return false;
		}

		$query = "select role_id from user_role where user_id=%d";
		foreach ($users as &$user) {
			if (($roles = $db->execute($query, $user["id"])) === false) {
				return false;
			}
			$user["roles"] = array_flatten($roles);
		}

		return $users;
	}

	function get_private_modules($db) {
		$result = array();

		if (($resource = $db->query("show create table %S", "roles")) != false) {
			$data = $db->fetch($resource);
			$create = explode("\n", $data["Create Table"]);
			foreach ($create as $line) {
				if (strstr($line, "tinyint")) {
					list(, $page) = explode("`", $line);
					array_push($result, $page);
				}
			}
		}

		sort($result);

		return $result;
	}

	function get_private_pages($db) {
		$query = "select id, url from pages where private=1 order by url";
		if (($pages = $db->execute($query)) === false) {
			return false;
		}

		$result = array();
		$query = "select * from page_access where page_id=%d";
		foreach ($pages as $page) {
			$page["access"] = array(ADMIN_ROLE_ID => 1);
			if (($access = $db->execute($query, $page["id"])) != false) {
				foreach ($access as $right) {
					$page["access"][$right["role_id"]] = $right["level"];
				}
			}
			array_push($result, $page);
		}

		return $result;
	}

	function get_all_roles($db) {
		$query = "select * from roles r order by name";

		return $db->execute($query);
	}
?>
