<?php
    class language_manager extends tablemanager {
		protected $name = "Language";
		protected $table = "languages";
		protected $pathinfo_offset = 2;
		protected $icon = "languages.png";
		protected $order = "page";
		protected $elements = array(
			"page" => array(
				"label"    => "Page",
				"type"     => "varchar",
				"default"  => "flash",
				"overview" => true,
				"required" => true),
			"name" => array(
				"label"    => "Name",
				"type"     => "varchar",
				"overview" => true,
				"required" => true));

		public function __construct($db, $user, $output, $language) {
			foreach ($language->supported as $language => $label) {
				$this->elements[$language] = array(
					"label"    => $label,
					"type"     => "text",
					"overview" => false,
					"required" => true);
			}

			parent::__construct($db, $user, $output);
		}

		protected function save_oke($item) {
			$result = parent::save_oke($item);

			if (valid_input($item["name"], VALIDATE_LETTERS."_", VALIDATE_NONEMPTY) == false) {	
				$this->output->add_message("Invalid name");
				$result = false;
			}

			return $result;
		}

		protected function update_item($item) {
			$this->output->remove_from_cache("language");

			return parent::update_item($item);
		}

		protected function delete_item($item_id) {
			$this->output->remove_from_cache("language");
			
			return parent::delete_item($item_id);
		}
	}
?>
