<?php
	function get_menu($db, $menu_id) {
		return $db->entry("menu", $menu_id);
	}

	function get_menu_items($db, $parent_id) {
		$query = "select *,(select count(*) from menu where parent_id=m.id) as children ".
		         "from menu m where parent_id=%d order by %S";
		return $db->execute($query, $parent_id, "order");
	}

	function menu_oke($db, $data) {
		global $_output;

		$result = true;

		if ($data["menu_id"] !== "0") {
			if ($db->entry("menu", $data["menu_id"]) == false) {
				$_output->add_message("Menu not found.");
				$result = false;
			}
		}

		if (is_array($data["menu"])) {
			foreach ($data["menu"] as $item) {
				if (($item["text"] == "") && ($item["link"] != "")) {
					$_output->add_message("Text can't be empty.");
					$result = false;
					break;
				}
			}
		}

		return $result;
	}

	function update_menu($db, $parent_id, $menu) {
		if (count($menu) == 0) {
			$query = "delete from menu where parent_id=%d";
			return $db->query($query, $parent_id) != false;
		}

		foreach ($menu as $id => $item) {
			if (trim($item["text"]) == "") {
				unset($menu[$id]);
			}
		}

		$db->query("begin");

		/* Delete items
		 */
		$query = "select * from menu where parent_id=%d";
		if (($current = $db->execute($query, $parent_id)) === false) {
			$db->query("rollback");
			return false;
		}

		$ids = array_keys($menu);
		foreach ($current as $item) {
			if (in_array($item["id"], $ids) == false) {
				if ($db->delete("menu", $item["id"]) === false) {
					$db->query("rollback");
					return false;
				}
			}
		}

		/* Add items
		 */
		$keys = array("id", "parent_id", "order", "text", "link");
		foreach ($menu as $id => $item) {
			if ($id < 0) {
				$item["id"] = null;
				$item["parent_id"] = $parent_id;
				$item["order"] = 10;
				if ($db->insert("menu", $item, $keys) === false) {
					$db->query("rollback");
					return false;
				}
				$menu[$id]["id"] = $db->last_insert_id;
			} else {
				$menu[$id]["id"] = $id;
			}
		}

		/* Sort menu
		 */
		$order = 1;
		$keys = array("order", "text", "link");
		foreach ($menu as $item) {
			$item["order"] = $order++;
			if ($db->update("menu", $item["id"], $item, $keys) === false) {
				$db->query("rollback");
				return false;
			}
		}

		return $db->query("commit") != false;
	}
?>
