<?php
	function get_all_roles($db) {
		$query = "select *, (select count(*) from user_role where role_id=r.id) as users from roles r order by name";

		return $db->execute($query);
	}

	function get_role($db, $role_id) {
		return $db->entry("roles", $role_id);
	}

	function get_role_members($db, $role_id) {
		$query = "select u.id, u.fullname from users u, user_role m ".
		         "where u.id=m.user_id and m.role_id=%d order by u.fullname";

		return $db->execute($query, $role_id);
	}

	function get_restricted_pages($db) {
		$result = array();

		if (($resource = $db->query("show create table %S", "roles")) != false) {
			$data = $db->fetch($resource);
			$create = explode("\n", $data["Create Table"]);
			foreach ($create as $line) {
				if (strstr($line, "tinyint")) {
					list(, $page) = explode("`", $line);
					array_push($result, $page);
				}
			}
		}

		sort($result);

		return $result;
	}

	function role_oke($role) {
		global $_output, $_user;

		$result = true;

		if ($role["id"] == ADMIN_ROLE_ID) {
			$_output->add_message("This role cannot be changed.");
			$result = false;
		}
		
		if ($role["name"] == "") {
			$_output->add_message("The name cannot be empty.");
			$result = false;
		}

		return $result;
	}

	function fix_role_data($keys, $role) {
		/* Work-around for PHP's nasty dot-to-underscore replacing
		 */
		foreach ($keys as $key) {
			if (isset($role[$key]) == false) {
				$alt_key = str_replace(".", "_", $key);
				$role[$key] = $role[$alt_key];
			}
		}

		return $role;
	}

	function create_role($db, $role) {
		$keys = get_restricted_pages($db);

		$role = fix_role_data($keys, $role);

		foreach ($keys as $key) {
			$role[$key] = is_true($role[$key]) ? YES : NO;
		}
		array_unshift($keys, "id", "name");

		$role["id"] = null;

		return $db->insert("roles", $role, $keys) !== false;
	}

	function update_role($db, $role) {
		$keys = get_restricted_pages($db);

		$role = fix_role_data($keys, $role);

		foreach ($keys as $key) {
			$role[$key] = is_true($role[$key]) ? YES : NO;
		}

		array_unshift($keys, "name");

		return $db->update("roles", $role["id"], $role, $keys) !== false;
	}

	function delete_role($db, $role_id) {
		$queries = array(
			array("delete from page_access where role_id=%d", $role_id),
			array("delete from user_role where role_id=%d", $role_id),
			array("delete from roles where id=%d", $role_id));

		return $db->transaction($queries);
	}
?>
