<?php
	class table_manager extends tablemanager {
		protected $name = "Webserver";
		protected $table = "webservers";
		protected $pathinfo_offset = 2;
		protected $back = "admin";
		protected $icon = "webserver.png";
		protected $elements = array(
			"name" => array(
				"label"    => "Name",
				"type"     => "varchar",
				"overview" => true,
				"required" => true),
			"ip_address" => array(
				"label"    => "IP address",
				"type"     => "varchar",
				"overview" => true,
				"required" => true),
			"port" => array(
				"label"    => "Port",
				"type"     => "integer",
				"default"  => "80",
				"overview" => false,
				"required" => true),
			"ssl" => array(
				"label"    => "SSL",
				"type"     => "boolean",
				"overview" => false,
				"required" => true),
			"active" => array(
				"label"    => "Active",
				"type"     => "boolean",
				"default"  => true,
				"overview" => true,
				"required" => true));

		public function delete_oke($item_id) {	
			global $_output;

			foreach (array("requests", "statistics") as $table) {
				$query = "select count(*) as count from %S  where webserver_id=%d";
				if (($result = $this->db->execute($query, $table, $item_id)) === false) {
					return false;
				}
				if ($result[0]["count"] > 0) {
					$_output->add_message("Webserver is in use.");
					return false;
				}
			}

			return true;
		}
	}
?>
