<?php
	function get_statistics($db, $begin, $end, $filter_hostname, $filter_webserver) {
		$query = "select * from host_statistics where ".
		         "((timestamp_begin>%s and timestamp_begin<%s) or ".
				 "(timestamp_end>%s and timestamp_end<%s))";

		$filter_args = array();
		if ($filter_hostname != 0) {
			$query .= " and hostname_id=%d";
			array_push($filter_args, $filter_hostname);
		}
		if ($filter_webserver != 0) {
			$query .= " and webserver_id=%d";
			array_push($filter_args, $filter_webserver);
		}

		$query .= " limit %d,%d";

		$timestamp_begin = strtotime($begin);
		$timestamp_end = strtotime($end);

		$stats = array(
			"requests"              => 0,
			"bytes_sent"            => 0,
			"bans"                  => 0,
			"exploit_attempts"      => 0,
			"result_forbidden"      => 0,
			"result_not_found"      => 0,
			"result_internal_error" => 0);
		$stats_keys = array_keys($stats);

		$result = array();
		$timestamp = $timestamp_begin;
		while ($timestamp < $timestamp_end) {
			$day = date("Y-m-d", $timestamp);
			$result[$day] = $stats;
			$timestamp += DAY;
		}
		
		$offset = 0;
		$limit = 3000;
		do {
			if (($entries = $db->execute($query, $begin, $end, $begin, $end, $filter_args, $offset, $limit)) === false) {
				return false;
			}

			#while (($entry = $db->fetch($resource)) !== false) {
			foreach ($entries as $entry) {
				$entry["timestamp_begin"] = strtotime($entry["timestamp_begin"]);
				$entry["timestamp_end"] = strtotime($entry["timestamp_end"]);

				$day = date("Y-m-d", $entry["timestamp_begin"]);
				$day_end = date("Y-m-d", $entry["timestamp_end"]);

				if ($day == $day_end) {
					$percentage = 1;
				} else if ($entry["timestamp_begin"] < $timestamp_begin) {
					/* Entry begins before begin time
					 */
					if (($timespan = $entry["timestamp_end"] - $entry["timestamp_begin"]) == 0) {
						continue;
					}
					$overtime = $timestamp_begin - $entry["timestamp_begin"];
					$percentage = ($timespan - $overtime) / $timespan;
				} else if ($entry["timestamp_end"] > $timestamp_end) {
					/* Entry ends after end time
					 */
					if (($timespan = $entry["timestamp_end"] - $entry["timestamp_begin"]) == 0) {
						continue;
					}
					$overtime = $entry["timestamp_end"] - $timestamp_end;
					$percentage = ($timespan - $overtime) / $timespan;
				} else {
					/* Entry spans two days
					 */
					$break = strtotime($day_end." 00:00:00");
					if (($timespan = $entry["timestamp_end"] - $entry["timestamp_begin"]) == 0) {
						continue;
					}
					$percentage = ($break - $entry["timestamp_begin"]) / $timespan;

					foreach ($stats_keys as $key) {
						$result[$day_end][$key] += (1 - $percentage) * $entry[$key];
					}
				}

				foreach ($stats_keys as $key) {
					$result[$day][$key] += $percentage * $entry[$key];
				}
			}

			$offset += $limit;
		} while (count($entries) > 0);

		foreach ($result as &$day) {
			foreach ($day as &$value) {
				$value = round($value);
			}
		}
		ksort($result);

		return $result;
	}

	function readable_number($number) {
		if ($number > 1000000) {
			return sprintf("%dM", $number / 1000000);
		} else if ($number > 10000) {
			return sprintf("%0.1fk", $number / 1000);
		}

		return $number;
	}
?>
