<?php
	function get_referers($db, $begin, $end, $filter_hostname, $filter_webserver) {
		$query = "select count(*) as count, f.referer from requests r, referers f ".
		         "where r.referer_id=f.id and timestamp>%s and timestamp<%s ".
		         "and substring(f.referer, 1, 4)=%s";

		$filter_args = array();
		if ($filter_hostname != 0) {
			$query .= " and r.hostname_id=%d";
			array_push($filter_args, $filter_hostname);
		}
		if ($filter_webserver != 0) {
			$query .= " and r.webserver_id=%d";
			array_push($filter_args, $filter_webserver);
		}

		$query .= " group by f.referer order by count desc";

		if (($entries = $db->execute($query, $begin, $end, "http", $filter_args)) === false) {
			return false;
		}

		$result = array(
			"hostnames" => array(),
			"referers"  => array());
		foreach ($entries as $entry) {
			list(,, $hostname) = explode("/", $entry["referer"], 4);
			$hostname = str_replace("www.", "", $hostname);

			$result["hostnames"][$hostname] += $entry["count"];
			if (is_array($result["referers"][$hostname]) == false) {
				$result["referers"][$hostname] = array();
			}
			array_push($result["referers"][$hostname], $entry);
		}

		arsort($result["hostnames"]);

		return $result;
	}
?>
