<?php
	/* public/ajax.php
	 *
	 * Copyright (C) by Hugo Leisink <hugo@leisink.net>
	 * This file is part of the Banshee PHP framework
	 * http://www.hiawatha-webserver.org/banshee
	 *
	 * Don't change this file, unless you know what you are doing.
	 */

	require("../libraries/settings.php");
	require("../libraries/security.php");
	require("../libraries/general.php");

	/* Check for IP bans
	 */
	check_ip_bans(BANNED_IPS);

	/* Abort on dangerous PHP settings
	 */
	check_PHP_setting("register_globals", 0);
	check_PHP_setting("allow_url_include", 0);

	/* Secure the submitted data
	 */
	$superglobals = array(&$_REQUEST, &$_GET, &$_POST, &$_COOKIE);
	foreach ($superglobals as &$superglobal) {
		$superglobal = secure_input($superglobal);
	}

	/* Start PHP session
	 */
	session_name(SESSION_NAME);
	session_start();

	/* Connect to the database
	 */
	$db      = new MySQLi_connection(DB_HOSTNAME, DB_DATABASE, DB_USERNAME, DB_PASSWORD);
	$_user   = new user($db);
	$_page   = new page($db, $_user, true);
	$_output = new output($db, $_page);

	/* Include the model
	 */
	if (file_exists($file = "../models/".$_page->module.".php")) {
		include($file);
	}

	$_output->open_tag("output");

	/* Include the controller
	 */
	if (file_exists($file = "../ajax/".$_page->module.".php")) {
		include($file);
	}

	$_output->close_tag();

	/* Output content
	 */
	$_output->generate("xml");
?>
