<?xml version="1.0" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:include href="includes/banshee.xslt" />

<!--
//
//  URIs template
//
//-->
<xsl:template match="uris">
<xsl:for-each select="uri">
<div class="uri"><xsl:value-of select="request_uri" /></div>
<div class="count"><xsl:value-of select="count" /></div>
</xsl:for-each>
</xsl:template>

<!--
//
//  Result template
//
//-->
<xsl:template match="result">
<p><xsl:value-of select="." /></p>
<xsl:choose>
	<xsl:when test="@url">
		<xsl:call-template name="redirect"><xsl:with-param name="url" select="@url" /></xsl:call-template>
	</xsl:when>
	<xsl:otherwise>
		<xsl:call-template name="redirect" />
	</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!--
//
//  Content template
//
//-->
<xsl:template match="content">
<h1>Not Founds</h1>
<xsl:apply-templates select="uris" />
<xsl:apply-templates select="result" />
</xsl:template>

</xsl:stylesheet>
