<?xml version="1.0" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:include href="functions.xslt" />
<xsl:include href="layout_site.xslt" />
<xsl:include href="layout_cms.xslt" />

<xsl:output method="html" encoding="utf-8" doctype-public="-//W3C//DTD HTML 4.01//EN" doctype-system="http://www.w3.org/TR/html4/strict.dtd" />

<xsl:template match="filter">
<div class="filter">
<form action="/{/output/page}" method="post">
<span>Host: <select class="text" name="hostname" onChange="javascript:submit()">
<xsl:for-each select="hostnames/hostname">
	<option value="{@id}">
		<xsl:if test="@selected='yes'"><xsl:attribute name="selected">selected</xsl:attribute></xsl:if>
		<xsl:value-of select="." />
	</option>
</xsl:for-each>
</select></span>
<span>Webserver: <select class="text" name="webserver" onChange="javascript:submit()">
<xsl:for-each select="webservers/webserver">
	<option value="{@id}">
		<xsl:if test="@selected='yes'"><xsl:attribute name="selected">selected</xsl:attribute></xsl:if>
		<xsl:value-of select="." />
	</option>
</xsl:for-each>
</select></span>
<input type="hidden" name="submit_button" value="filter" />
</form>
</div>
</xsl:template>

<xsl:template match="/output">
<xsl:apply-templates select="layout_site" />
<xsl:apply-templates select="layout_empty" />
<xsl:apply-templates select="layout_cms" />
</xsl:template>

</xsl:stylesheet>
